/*
 * Decompiled with CFR 0.152.
 */
package Main;

import GameState.GameStateManager;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final int WIDTH = 800;
    public static final int HEIGHT = 400;
    public static final int SCALE = 1;
    private Thread thread;
    private boolean running;
    private int FPS = 60;
    long framerate = 1000 / this.FPS;
    long frameStart;
    long frameCount = 0L;
    long elapsedTime;
    long totalElapsedTime = 0L;
    static long reportedFramerate;
    private BufferedImage image;
    private Graphics2D g;
    private GameStateManager gsm;

    public GamePanel() {
        this.setPreferredSize(new Dimension(800, 400));
        this.setFocusable(true);
        this.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.thread.start();
        }
    }

    private void init() throws IOException {
        this.image = new BufferedImage(800, 400, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.running = true;
        this.gsm = new GameStateManager();
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            Options.init();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        while (this.running) {
            this.frameStart = System.currentTimeMillis();
            this.update();
            this.draw();
            this.drawToScreen();
            this.elapsedTime = System.currentTimeMillis() - this.frameStart;
            try {
                if (this.elapsedTime < this.framerate) {
                    Thread.sleep(this.framerate - this.elapsedTime);
                } else {
                    Thread.sleep(5L);
                }
            }
            catch (InterruptedException e) {
                break;
            }
            ++this.frameCount;
            this.totalElapsedTime += System.currentTimeMillis() - this.frameStart;
            if (this.totalElapsedTime <= 1000L) continue;
            reportedFramerate = (long)((double)this.frameCount / (double)this.totalElapsedTime * 1000.0);
            this.draw();
            this.frameCount = 0L;
            this.totalElapsedTime = 0L;
        }
    }

    private void update() {
        this.gsm.update();
        Keys.update();
    }

    private void draw() {
        this.gsm.draw(this.g);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 800, 400, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent key) {
        Keys.keySet(key.getKeyCode(), true);
    }

    @Override
    public void keyReleased(KeyEvent key) {
        Keys.keySet(key.getKeyCode(), false);
    }

    @Override
    public void keyTyped(KeyEvent key) {
    }

    public static int getFPS() {
        return (int)reportedFramerate;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Keys.mouseSet(e.getButton(), true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Keys.isDown = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Keys.isDown = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.setCursor(transparentCursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Keys.mouseX = -100;
        Keys.mouseY = -100;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Keys.mouseX = e.getX();
        Keys.mouseY = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Keys.mouseX = e.getX();
        Keys.mouseY = e.getY();
    }
}

